﻿requirejs.config({
    baseUrl: "/js/modules",
    paths: {
        'angular': '/js/libs/angular.min',
        'resource': "/js/libs/angular-resource.min",
        'angular-cookies': "/js/libs/angular-cookies.min",
        'angular-sanitize':'/js/libs/angular-sanitize.min',
        'bootstrap': "/js/libs/bootstrap.min",
        'patternsRegExp': "/js/libs/patternsRegExp",
        'masks': "/js/libs/masks",
        'route': '/js/libs/angular-ui-router.min',
        'datepicker': '/js/libs/bootstrap-datepicker',
        'underscore': '/js/libs/underscore-min',
        'jquery': "/js/libs/jquery-1.11.1.min",
        'jquery-migrate': '/js/libs/jquery-migrate-1.2.1.min',
        'jquery.dynatree': '/js/libs/jquery.dynatree',
        'jquery-ui': '/js/libs/jquery-ui-1.10.4.min',
        'common': '/js/common',
        'app': '/js/app-init',
        'jetmenu': '/js/libs/jetmenu',
        'typeahead': '/js/libs/bootstrap-typeahead',
        'jquery.maskedinput': '/js/libs/jquery.inputmask.bundle',
        'ng-table': '/js/libs/ng-table.src',
        'search': '/js/search',
        'homepage': '/js/homepage',
        'jquery-autocomplete-combo': '/js/libs/jquery-autocomplete-combo',
        'toastr': '/js/libs/toastr.min',
        'crop': '/js/libs/jquery.Jcrop.min',
        'gallery': '/js/libs/grid',
        'modernizr': '/js/libs/modernizr.custom',
        'tinymce': '/js/libs/tinymce/tinymce.min',
        'tinymce-angular': '/js/libs/tinymce',
        'storageapi':'/js/libs/jquery.storageapi.min',
        'owlcarousel': '/js/libs/owl.carousel.min',
        'main': '/js/main',
        'camera': '/js/libs/camera.min',
        'lightcase': '/js/libs/lightcase',
        'jquery-easing': '/js/libs/jquery.easing.1.3',
        'angular-datepicker': '/js/libs/angular-datepicker',
        'ui-bootstrap': '/js/libs/ui-bootstrap-tpls.min',
        'bootstrap-select': '/js/libs/bootstrap-select.min',
        'dropdown-multiselect': '/js/libs/bootstrap-multiselect',

        //virtual-keyboard
        helpers:"/js/libs/virtual-keyboard/extensions/helpers",
        dom: "/js/libs/virtual-keyboard/extensions/dom",
        documentcookie: "/js/libs/virtual-keyboard/extensions/documentcookie",
        eventmanager: "/js/libs/virtual-keyboard/extensions/eventmanager",
        virtualkeyboard: "/js/libs/virtual-keyboard/virtualkeyboard",
        vk_loader: "/js/libs/virtual-keyboard/vk_loader",
    },
    shim: {
        'angular': {
            exports: "angular"
        },
        'jquery': {
            exports: "$"
        },
        'tinymce': ["jquery"],
        'tinymce-angular': ['angular', "jquery", 'tinymce'],
        'route': ["angular"],
        'resource': ["angular"],
        'angular-cookies': ["angular"],
        'angular-sanitize': ["angular"],
        'ui-bootstrap': ["angular"],
        'angular-datepicker': ["angular", 'ui-bootstrap'],
        'crop': ["jquery"],
        'bootstrap': ["jquery"],
        'jquery-ui': ["jquery"],
        'jquery-migrate': ['jquery'],
        'jquery.dynatree': ['jquery-ui'],
        'jetmenu': ['jquery'],
        'owlcarousel': ['jquery'],
        'gallery': ['jquery', 'modernizr'],
        'lightcase': ['jquery'],
        'app': ['jquery', 'jetmenu', 'bootstrap', 'jquery-migrate'],
        'typeahead': ['bootstrap'],
        'ng-table': ["angular"],
        'datepicker': ["jquery"],
        'jquery.maskedinput': ["jquery"],
        'jquery-autocomplete-combo': ['jquery-ui'],
        'toastr': ['jquery'],
        'virtualkeyboard': ['helpers', 'dom', 'documentcookie', 'eventmanager'],
        'vk_loader': ['virtualkeyboard'],
        'dom': ['helpers'],
        'documentcookie': ['helpers'],
        'eventmanager': ['helpers'],
        'dropdown-multiselect': ["bootstrap"],
        'jquery-easing': ['jquery'],
        'camera': ['jquery', 'jquery-easing'],
        'bootstrap-select': ['jquery']
    },
    waitSeconds:60
   ,urlArgs: "v=20"
});


require(['app'], function () {
    require(['main-module'], function (model) {
        var el = $("#search-filter");
        angular.bootstrap(el, [model.name]);
    })
});